<p align="center"><img src="/art/logo.svg" alt="Logo Laravel Echo"></p>

<p align="center">
<a href="https://github.com/laravel/echo/actions"><img src="https://github.com/laravel/echo/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://www.npmjs.com/package/laravel-echo"><img src="https://img.shields.io/npm/dt/laravel-echo" alt="Total Downloads"></a>
<a href="https://www.npmjs.com/package/laravel-echo"><img src="https://img.shields.io/npm/v/laravel-echo" alt="Latest Stable Version"></a>
<a href="https://www.npmjs.com/package/laravel-echo"><img src="https://img.shields.io/npm/l/laravel-echo" alt="License"></a>
</p>

## Introduction

In many modern web applications, WebSockets are used to implement realtime, live-updating user interfaces. When some data is updated on the server, a message is typically sent over a WebSocket connection to be handled by the client. This provides a more robust, efficient alternative to continually polling your application for changes.

To assist you in building these types of applications, Laravel makes it easy to "broadcast" your events over a WebSocket connection. Broadcasting your Laravel events allows you to share the same event names between your server-side code and your client-side JavaScript application.

Laravel Echo is a JavaScript library that makes it painless to subscribe to channels and listen for events broadcast by Laravel. You may install Echo via the NPM package manager.

## Official Documentation

Documentation for Echo can be found on the [Laravel website](https://laravel.com/docs/broadcasting).

## Contributing

Thank you for considering contributing to Echo! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

Please review [our security policy](https://github.com/laravel/echo/security/policy) on how to report security vulnerabilities.

## License

Laravel Echo is open-sourced software licensed under the [MIT license](LICENSE.md).
