"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return TerminalListener;
    }
});
let TerminalListener = class TerminalListener {
    /**
   * Returns MetaApiConnection instance
   * @return {MetaApiConnection} MetaApiConnection instance
   */ get connection() {
        return this._connection;
    }
    /**
   * Sets MetaApiConnection instance
   * @param {MetaApiConnection} connection MetaApiConnection instance
   */ set connection(connection) {
        this._connection = connection;
    }
    /**
   * Invoked when connection to MetaTrader terminal established
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onConnected() {}
    /**
   * Invoked when connection to MetaTrader terminal terminated
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onDisconnected() {}
    /**
   * Invoked when broker connection satus have changed
   * @param {Boolean} connected is MetaTrader terminal is connected to broker
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onBrokerConnectionStatus(connected) {}
    /**
   * Invoked when MetaTrader terminal state synchronization is started
   * @param {string} instanceIndex index of an account instance connected
   * @param {string} specificationsHash specifications hash
   * @param {string} positionsHash positions hash
   * @param {string} ordersHash orders hash
   * @param {string} synchronizationId synchronization id
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ onSynchronizationStarted(instanceIndex, specificationsHash, positionsHash, ordersHash, synchronizationId) {}
    /**
   * Invoked when MetaTrader account information is updated
   * @param {MetatraderAccountInformation} accountInformation updated MetaTrader account information
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onAccountInformationUpdated(accountInformation) {}
    /**
   * Invoked when the positions are replaced as a result of initial terminal state synchronization. This method
   * will be invoked only if server thinks the data was updated, otherwise invocation can be skipped
   * @param {Array<MetatraderPosition>} positions updated array of positions
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPositionsReplaced(positions) {}
    /**
   * Invoked when position synchronization fnished to indicate progress of an initial terminal state synchronization
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPositionsSynchronized() {}
    /**
   * Invoked when MetaTrader position is updated
   * @param {MetatraderPosition} position updated MetaTrader position
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPositionUpdated(position) {}
    /**
   * Invoked when MetaTrader position is removed
   * @param {String} positionId removed MetaTrader position id
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPositionRemoved(positionId) {}
    /**
   * Invoked when the pending orders are replaced as a result of initial terminal state synchronization. This method
   * will be invoked only if server thinks the data was updated, otherwise invocation can be skipped
   * @param {Array<MetatraderOrder>} orders updated array of pending orders
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPendingOrdersReplaced(orders) {}
    /**
   * Invoked when MetaTrader pending order is updated
   * @param {MetatraderOrder} order updated MetaTrader pending order
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPendingOrderUpdated(order) {}
    /**
   * Invoked when MetaTrader pending order is completed (executed or canceled)
   * @param {String} orderId completed MetaTrader pending order id
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPendingOrderCompleted(orderId) {}
    /**
   * Invoked when pending order synchronization fnished to indicate progress of an initial terminal state
   * synchronization
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onPendingOrdersSynchronized() {}
    /**
   * Invoked when a new MetaTrader history order is added
   * @param {MetatraderOrder} historyOrder new MetaTrader history order
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onHistoryOrderAdded(historyOrder) {}
    /**
   * Invoked when a synchronization of history orders on a MetaTrader account have finished to indicate progress of an
   * initial terminal state synchronization
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onHistoryOrdersSynchronized() {}
    /**
   * Invoked when a new MetaTrader history deal is added
   * @param {MetatraderDeal} deal new MetaTrader history deal
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onDealAdded(deal) {}
    /**
   * Invoked when a synchronization of history deals on a MetaTrader account have finished to indicate progress of an
   * initial terminal state synchronization
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onDealsSynchronized() {}
    /**
   * Invoked when a symbol specification was updated
   * @param {MetatraderSymbolSpecification} specification updated MetaTrader symbol specification
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onSymbolSpecificationUpdated(specification) {}
    /**
   * Invoked when a symbol specification was removed
   * @param {String} symbol removed symbol
   * @returns {Promise} promise which resolves when the asynchronous event is processed
   */ async onSymbolSpecificationRemoved(symbol) {}
    /**
   * Invoked when a symbol price was updated
   * @param {MetatraderSymbolPrice} quote updated MetaTrader symbol quote
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onQuote(quote) {}
    /**
   * Invoked when symbol candles were updated
   * @param {MetatraderCandle} candle updated MetaTrader symbol candle
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onCandle(candles) {}
    /**
   * Invoked when symbol ticks were updated
   * @param {MetatraderTick} tick updated MetaTrader symbol tick
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onTick(tick) {}
    /**
   * Invoked when order books were updated
   * @param {MetatraderBook} book updated MetaTrader order book
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onBook(book) {}
    /**
   * Invoked when subscription downgrade has occurred
   * @param {string} symbol symbol to update subscriptions for
   * @param {Array<MarketDataSubscription>} updates array of market data subscription to update
   * @param {Array<MarketDataUnsubscription>} unsubscriptions array of subscriptions to cancel
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ async onSubscriptionDowngraded(symbol, updates, unsubscriptions) {}
};

//# sourceMappingURL=data:application/json;base64,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