<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
   <meta name="description" content="<?php echo e($settings->site_name); ?> - Powerful, fully-featured investment and trading platform. Access investment plans, cryptocurrency trading, stock trading, copy trading, automated bot trading, staking, and stock investment. Professional trading solutions for everyone.">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>">
    <title><?php echo e($settings->site_name); ?> • <?php echo $__env->yieldContent('title', 'Crypto Trading Platform'); ?></title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer">
    
    <!-- Owl Carousel -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">

    <style>
        .poppins-light { font-family: "Poppins", sans-serif; font-weight: 300; }
        .poppins-regular { font-family: "Poppins", sans-serif; font-weight: 400; }
        .poppins-medium { font-family: "Poppins", sans-serif; font-weight: 500; }
        .poppins-semibold { font-family: "Poppins", sans-serif; font-weight: 600; }
        .poppins-bold { font-family: "Poppins", sans-serif; font-weight: 700; }
        .manrope { font-family: "Manrope", sans-serif; }
        
        body { font-family: "Manrope", sans-serif; overflow-x: hidden; }
        
        .owl-item { display: flex; align-items: center; justify-content: center; }
        .owl-carousel .item img { height: 100px; object-fit: contain; }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #f1f5f9; }
        ::-webkit-scrollbar-thumb { background: #94a3b8; border-radius: 4px; }
        ::-webkit-scrollbar-thumb:hover { background: #64748b; }
    </style>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#0F9D58',
                        'primary-dark': '#0B8046',
                    }
                }
            }
        }
    </script>
</head>
<body class="overflow-x-hidden w-screen">
    <!-- WhatsApp Button -->
    <?php if(!empty($settings->whatsapp)): ?>
    <a href="https://wa.me/<?php echo e($settings->whatsapp); ?>" target="_blank" rel="noopener noreferrer" class="fixed bottom-4 left-4 bg-green-500 text-white p-3 rounded-full shadow-lg hover:bg-green-600 transition-colors duration-300 z-50">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor">
            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
        </svg>
    </a>
    <?php endif; ?>

    <!-- Navigation -->
    <nav class="flex justify-between box-content py-5 px-5 manrope font-semibold text-sm shadow-lg shadow-[rgba(1, 5, 34, 0.03)] sticky top-0 z-50 bg-white">
        <div class="flex gap-10 items-center">
            <button id="menu-toggle" class="md:hidden">
                <i class="fa fa-bars text-xl"></i>
            </button>
            <a href="index" class="flex items-center">
                <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-8 md:h-10">
            </a>
            <div class="hidden md:flex gap-5">
                <a href="index" class="text-primary hover:text-primary-dark transition-colors">Home</a>
                <a href="about" class="hover:text-primary transition-colors">About</a>
                <a href="services" class="hover:text-primary transition-colors">Services</a>
                <a href="contact" class="hover:text-primary transition-colors">Contact</a>
            </div>
        </div>
        <div class="flex gap-3 md:gap-5 items-center">
            <a href="login" class="bg-[#E8F5F0] text-primary rounded-full px-3 md:px-4 py-1 text-xs md:text-sm hover:bg-[#D1EBE1] transition-colors">Login</a>
            <a href="register" class="bg-primary text-white rounded-full px-3 md:px-4 py-1 text-xs md:text-sm hover:bg-primary-dark transition-colors">Sign up</a>
        </div>
    </nav>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="hidden fixed inset-0 bg-white z-50 p-5 poppins-medium transition-transform duration-300 ease-in-out transform -translate-x-full">
        <div class="flex justify-center items-center mb-5">
            <button id="close-menu" class="text-2xl font-bold text-white rounded-full bg-black w-8 h-8 flex items-center justify-center absolute top-5 left-5">
                <i class="fa-solid fa-xmark"></i>
            </button>
            <div class="text-center font-semibold text-lg">Menu</div>
        </div>
        <div class="flex flex-col text-[#010522] *:border-b-[1px] *:border-[#0000003d] *:py-6">
            <a href="index">Home</a>
            <a href="about">About</a>
            <a href="services">Services</a>
            <a href="contact" style="border-bottom: none">Contact</a>
        </div>
    </div>

    <!-- Main Content -->
    <main class="flex-grow">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Toast Notification -->
    <div id="toast" class="hidden fixed bottom-10 right-10 z-50 p-4 bg-white text-black rounded-lg shadow-lg border border-primary max-w-md"></div>

    <!-- Footer -->
    <div class="bg-[#010522] manrope text-sm text-white">
        <div class="h-[100px] bg-gradient-to-b to-90% to-[#010522] from-primary"></div>
        <footer class="md:box-content py-5 pt-0 px-5 bg-[#010522] manrope text-sm text-white container mx-auto">
            <div class="flex flex-col md:flex-row gap-5 items-center justify-center w-full my-10 md:my-20">
                <div>
                    <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-12 md:h-16">
                </div>
                <div class="text-xl md:text-4xl poppins-regular text-center">Pro Trading, <span class="poppins-semibold">For Everyone.</span></div>
                <a href="register" class="bg-primary py-2 px-5 rounded-full text-white ml-0 md:ml-4 hover:bg-primary-dark transition-colors">Get Started</a>
            </div>

            <!-- Investor Logos Carousel -->
            <div class="text-center font-bold mb-10">Our Partners</div>
            <div id="investor-slides">
                <div class="owl-carousel owl-theme">
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/1.png')); ?>" alt="Partner 1" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/2.png')); ?>" alt="Partner 2" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/3.png')); ?>" alt="Partner 3" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/4.png')); ?>" alt="Partner 4" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/5.png')); ?>" alt="Partner 5" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/6.png')); ?>" alt="Partner 6" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/7.png')); ?>" alt="Partner 7" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/8.png')); ?>" alt="Partner 8" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                    <div class="item"><img src="<?php echo e(asset('temp/assets/images/brands/9.png')); ?>" alt="Partner 9" class="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"></div>
                </div>
            </div>
            
            <div class="text-white py-12 px-4 md:px-8">
                <div class="grid grid-cols-2 md:grid-cols-6 gap-8">
                    <div class="text-sm">
                        <h3 class="font-semibold mb-4">Company</h3>
                        <ul class="space-y-2 text-[#ffffff7a]">
                            <li><a href="about" class="hover:text-white transition-colors">About Us</a></li>
                            <li><a href="services" class="hover:text-white transition-colors">Services</a></li>
                            <li><a href="contact" class="hover:text-white transition-colors">Contact</a></li>
                            <li><a href="terms" class="hover:text-white transition-colors">Terms</a></li>
                        </ul>
                    </div>
                    
                    <div class="text-sm">
                        <h3 class="font-semibold mb-4">Products</h3>
                        <ul class="space-y-2 text-[#ffffff7a]">
                            <li><a href="services" class="hover:text-white transition-colors">Trading</a></li>
                            <li><a href="services" class="hover:text-white transition-colors">Investment</a></li>
                            <li><a href="services" class="hover:text-white transition-colors">Crypto</a></li>
                            <li><a href="services" class="hover:text-white transition-colors">Stocks</a></li>
                        </ul>
                    </div>
                    
                    <div class="text-sm">
                        <h3 class="font-semibold mb-4">Support</h3>
                        <ul class="space-y-2 text-[#ffffff7a]">
                            <li><a href="contact" class="hover:text-white transition-colors">Help Center</a></li>
                            <li><a href="contact" class="hover:text-white transition-colors">FAQ</a></li>
                            <li><a href="contact" class="hover:text-white transition-colors">Support</a></li>
                        </ul>
                    </div>
                    
                    <div class="text-sm">
                        <h3 class="font-semibold mb-4">Legal</h3>
                        <ul class="space-y-2 text-[#ffffff7a]">
                            <li><a href="terms" class="hover:text-white transition-colors">Privacy Policy</a></li>
                            <li><a href="terms" class="hover:text-white transition-colors">Terms of Service</a></li>
                            <li><a href="terms" class="hover:text-white transition-colors">Cookie Policy</a></li>
                        </ul>
                    </div>
                    
                    <div class="text-sm col-span-2">
                        <h3 class="font-semibold mb-4">Contact Info</h3>
                        <ul class="space-y-2 text-[#ffffff7a]">
                            <li><i class="fas fa-envelope mr-2"></i><?php echo e($settings->contact_email); ?></li>
                            <li><i class="fas fa-map-marker-alt mr-2"></i><?php echo e($settings->address_o); ?></li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="flex flex-col md:flex-row items-center gap-4 py-8 px-4 md:px-8 border-t border-white/10">
                <div class="flex-shrink-0">
                    <img src="<?php echo e(asset('storage/app/public/' . $settings->logo)); ?>" alt="<?php echo e($settings->site_name); ?>" class="h-8">
                </div>
                <p class="text-[11px] font-light text-[#ffffff7a]"><?php echo e($settings->site_name); ?> is a licensed financial services provider</p>
                
                <div class="bg-[#ffffff7a] w-full h-px border-b-px flex-1 hidden md:block"></div>
                
                <div class="flex justify-center md:justify-start items-center gap-2 mt-4 md:mt-0 flex-shrink-0">
                    <a href="https://facebook.com" target="_blank" class="flex items-center justify-center w-8 h-8 rounded-full bg-[#ffffff14] hover:bg-[#2a56ff] transition-colors duration-200">
                        <i class="fab fa-facebook-f text-sm"></i>
                    </a>
                    <a href="https://twitter.com" target="_blank" class="flex items-center justify-center w-8 h-8 rounded-full bg-[#ffffff14] hover:bg-[#2a56ff] transition-colors duration-200">
                        <i class="fab fa-twitter text-sm"></i>
                    </a>
                    <a href="https://linkedin.com" target="_blank" class="flex items-center justify-center w-8 h-8 rounded-full bg-[#ffffff14] hover:bg-[#2a56ff] transition-colors duration-200">
                        <i class="fab fa-linkedin-in text-sm"></i>
                    </a>
                    <a href="https://instagram.com" target="_blank" class="flex items-center justify-center w-8 h-8 rounded-full bg-[#ffffff14] hover:bg-[#2a56ff] transition-colors duration-200">
                        <i class="fab fa-instagram text-sm"></i>
                    </a>
                </div>
            </div>
        </footer>
    </div>

    <!-- Back to Top Button -->
    <button id="back-to-top" class="fixed bottom-6 right-6 p-3 rounded-full bg-primary text-white shadow-lg transform transition-transform duration-300 hover:scale-110 focus:outline-none hidden z-40">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18" />
        </svg>
    </button>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

    <script>
        $(document).ready(function(){
            // Owl Carousel
            $(".owl-carousel").owlCarousel({
                autoplay: true,
                autoplayTimeout: 2000,
                loop: true,
                nav: false,
                dots: false,
                responsive: {
                    0: { items: 2 },
                    600: { items: 3 },
                    1000: { items: 6 }
                }
            });

            // Mobile Menu
            const menuToggle = document.getElementById('menu-toggle');
            const closeMenu = document.getElementById('close-menu');
            const mobileMenu = document.getElementById('mobile-menu');

            menuToggle.addEventListener('click', () => {
                mobileMenu.classList.remove('hidden');
                mobileMenu.classList.remove('-translate-x-full');
                mobileMenu.classList.add('translate-x-0');
                document.body.style.overflow = 'hidden';
            });

            closeMenu.addEventListener('click', () => {
                mobileMenu.classList.remove('translate-x-0');
                mobileMenu.classList.add('-translate-x-full');
                setTimeout(() => {
                    mobileMenu.classList.add('hidden');
                }, 300);
                document.body.style.overflow = 'auto';
            });

            // Back to Top
            $(window).scroll(function() {
                if ($(this).scrollTop() > 300) {
                    $('#back-to-top').fadeIn();
                } else {
                    $('#back-to-top').fadeOut();
                }
            });

            $('#back-to-top').click(function() {
                $('html, body').animate({scrollTop: 0}, 800);
                return false;
            });

            // Toast Notification
            window.showToast = function(message, duration = 3000) {
                const toast = $('#toast');
                toast.text(message);
                toast.removeClass('hidden').addClass('block');
                setTimeout(function() {
                    toast.removeClass('block').addClass('hidden');
                }, duration);
            };

            // Random Transaction Notifications
            const amounts = [30000, 45000, 11500, 16000, 8000, 10000, 13000, 17000, 29000, 30000, 16000, 28000, 21000, 51000, 12000, 17000, 25000, 9000, 50000, 4000];
            const countries = ["United States", "United Kingdom", "Canada", "Australia", "Germany", "France", "Japan", "China", "Brazil", "India", "Russia", "South Africa", "Mexico", "Spain", "Italy", "Netherlands", "Sweden", "Singapore", "United Arab Emirates", "Switzerland"];

            function showRandomTransaction() {
                const isInvestment = Math.random() < 0.5;
                const randomCountry = countries[Math.floor(Math.random() * countries.length)];
                const randomAmount = amounts[Math.floor(Math.random() * amounts.length)];
                
                let message = isInvestment 
                    ? `Someone from ${randomCountry} just invested $${randomAmount} in <?php echo e($settings->site_name); ?>`
                    : `Someone from ${randomCountry} just withdrew $${randomAmount} from <?php echo e($settings->site_name); ?>`;
                
                window.showToast(message, 3000);
            }

            setInterval(showRandomTransaction, 10000);
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    
    <?php echo $__env->make('layouts.livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/complex3/domains/remedybermbypromax.sbs/public_html/resources/views/layouts/base.blade.php ENDPATH**/ ?>