<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('title', 'Home'); ?>


<?php $__env->startSection('content'); ?>





    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
                <!-- Hero Section -->
    <section class="relative overflow-hidden">
    <div class="hero-slider relative h-[600px]">
        <!-- Slide 1 -->
        <div class="hero-slide-item absolute inset-0 w-full h-full bg-cover bg-center" style="background-image: url('img/2.jpg')">
            <div class="container mx-auto px-4 h-full flex items-center">
                <div class="max-w-xl text-white">
                    <span class="inline-block mb-4 text-gold-500 font-medium">Tesla In Co-operation With <?php echo e($settings->site_name); ?></span>
                    <h1 class="text-4xl md:text-5xl font-display font-bold mb-6 leading-tight">Your Tomorrow Starts From Here</h1>
                    <a href="register" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-horizon-700 hover:bg-horizon-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-horizon-500 transition-colors duration-200">
                        Get Started
                    </a>
                </div>
            </div>
        </div>

        <!-- Slide 2 -->
        <div class="hero-slide-item absolute inset-0 w-full h-full bg-cover bg-center" style="background-image: url('img/5.jpg'); display: none;">
            <div class="container mx-auto px-4 h-full flex items-center">
                <div class="max-w-xl text-white">
                    <span class="inline-block mb-4 text-gold-500 font-medium">Tesla In Co-operation With <?php echo e($settings->site_name); ?></span>
                    <h1 class="text-4xl md:text-5xl font-display font-bold mb-6 leading-tight">A New Approach To Trading</h1>
                    <a href="register" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-horizon-700 hover:bg-horizon-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-horizon-500 transition-colors duration-200">
                        Get Started
                    </a>
                </div>
            </div>
        </div>

        <!-- Slider Navigation -->
        <div class="absolute bottom-5 left-0 right-0 flex justify-center space-x-2">
            <button class="slider-dot w-3 h-3 rounded-full bg-white bg-opacity-50 focus:outline-none" data-slide="0"></button>
            <button class="slider-dot w-3 h-3 rounded-full bg-white bg-opacity-50 focus:outline-none" data-slide="1"></button>
        </div>
    </div>
</section>

    <!-- Services Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-display font-bold text-horizon-800 mb-4">Our Trading Services</h2>
                <p class="text-secondary-600 max-w-2xl mx-auto">Explore our comprehensive range of trading services designed to help you maximize your investment potential.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Crypto Currency Trading -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="text-gold-500 text-4xl mb-4 flex justify-center">
                        <i class="fas fa-coins"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-2">
                        <a href="services" class="hover:text-gold-500 transition-colors duration-200">Crypto Currency Trading</a>
                    </h3>
                    <p class="text-secondary-600">Trade popular cryptocurrencies with our advanced platform and expert guidance.</p>
                </div>

                <!-- Forex Trading -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="text-gold-500 text-4xl mb-4 flex justify-center">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-2">
                        <a href="services" class="hover:text-gold-500 transition-colors duration-200">Forex Trading</a>
                    </h3>
                    <p class="text-secondary-600">Access global currency markets with competitive spreads and reliable execution.</p>
                </div>

                <!-- Bonds And ETFs -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="text-gold-500 text-4xl mb-4 flex justify-center">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-2">
                        <a href="services" class="hover:text-gold-500 transition-colors duration-200">Bonds And ETFs</a>
                    </h3>
                    <p class="text-secondary-600">Diversify your portfolio with a wide range of bonds and exchange-traded funds.</p>
                </div>

                <!-- Stocks -->
                <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-8 text-center hover:shadow-md transition-shadow duration-300">
                    <div class="text-gold-500 text-4xl mb-4 flex justify-center">
                        <i class="fas fa-chart-bar"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-horizon-800 mb-2">
                        <a href="services" class="hover:text-gold-500 transition-colors duration-200">Stocks</a>
                    </h3>
                    <p class="text-secondary-600">Invest in global stocks with our intuitive platform and real-time market data.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="py-16">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Image Column -->
                <div class="relative">
                    <img src="img/men.webp" alt="Business Professional" class="w-full h-auto rounded-lg shadow-lg">
                    <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-white py-4 px-6 rounded-lg shadow-md text-center">
                        <p class="text-horizon-800 font-semibold">Successfully Providing Business<br>Solution for 10 Years</p>
                    </div>
                </div>

                <!-- Content Column -->
                <div>
                    <span class="text-horizon-700 font-medium">About</span>
                    <h2 class="text-3xl font-display font-bold text-horizon-800 mt-2 mb-6">Learn A Little About Us</h2>
                    <p class="text-secondary-700 mb-8"><?php echo e($settings->site_name); ?> is a leading financial services company and pioneer in the online brokerage industry. Having executed the first-ever electronic trade by an individual investor more than 10 years ago.</p>

                    <!-- Accordion -->
                    <div class="space-y-4" x-data="{selected:null}">
                        <!-- Trading Guides -->
                        <div class="border border-gray-200 rounded-lg overflow-hidden">
                            <button
                                @click="selected !== 1 ? selected = 1 : selected = null"
                                class="flex justify-between items-center w-full px-4 py-3 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                            >
                                <span>Trading Guides</span>
                                <svg
                                    :class="{'rotate-180': selected === 1}"
                                    class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                    xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 20 20"
                                    fill="currentColor"
                                >
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </button>
                            <div
                                x-show="selected === 1"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 transform -translate-y-4"
                                x-transition:enter-end="opacity-100 transform translate-y-0"
                                x-transition:leave="transition ease-in duration-150"
                                x-transition:leave-start="opacity-100 transform translate-y-0"
                                x-transition:leave-end="opacity-0 transform -translate-y-4"
                                class="px-4 py-3 bg-gray-50 text-secondary-600"
                            >
                                From technical analysis and risk management to market psychology and MT4 Tips and Tricks, these guides are ideal for traders of all levels.
                            </div>
                        </div>

                        <!-- Daily market commentary -->
                        <div class="border border-gray-200 rounded-lg overflow-hidden">
                            <button
                                @click="selected !== 2 ? selected = 2 : selected = null"
                                class="flex justify-between items-center w-full px-4 py-3 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                            >
                                <span>Daily market commentary</span>
                                <svg
                                    :class="{'rotate-180': selected === 2}"
                                    class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                    xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 20 20"
                                    fill="currentColor"
                                >
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </button>
                            <div
                                x-show="selected === 2"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 transform -translate-y-4"
                                x-transition:enter-end="opacity-100 transform translate-y-0"
                                x-transition:leave="transition ease-in duration-150"
                                x-transition:leave-start="opacity-100 transform translate-y-0"
                                x-transition:leave-end="opacity-0 transform -translate-y-4"
                                class="px-4 py-3 bg-gray-50 text-secondary-600"
                            >
                                Know what the market is thinking. Our in-house Market Analysts explain all you need to know for the day ahead in a single video.
                            </div>
                        </div>

                        <!-- Breaking news & analysis -->
                        <div class="border border-gray-200 rounded-lg overflow-hidden">
                            <button
                                @click="selected !== 3 ? selected = 3 : selected = null"
                                class="flex justify-between items-center w-full px-4 py-3 text-left text-horizon-800 font-medium hover:bg-gray-50 focus:outline-none"
                            >
                                <span>Breaking news & analysis</span>
                                <svg
                                    :class="{'rotate-180': selected === 3}"
                                    class="h-5 w-5 text-horizon-700 transform transition-transform duration-200"
                                    xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 20 20"
                                    fill="currentColor"
                                >
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </button>
                            <div
                                x-show="selected === 3"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 transform -translate-y-4"
                                x-transition:enter-end="opacity-100 transform translate-y-0"
                                x-transition:leave="transition ease-in duration-150"
                                x-transition:leave-start="opacity-100 transform translate-y-0"
                                x-transition:leave-end="opacity-0 transform -translate-y-4"
                                class="px-4 py-3 bg-gray-50 text-secondary-600"
                            >
                                Breaking market news, important economic events, key technical levels to watch. You will find it all in our Market News section.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    
    
    <!-- Investment Plans Section -->
<section class="py-20 bg-gradient-to-br from-white via-gray-50 to-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-14">
            <span class="text-gold-500 font-semibold tracking-wide uppercase">Our Plans</span>
            <h2 class="text-4xl font-display font-extrabold text-horizon-800 mt-2">Choose Your Investment Plan</h2>
            <p class="text-secondary-600 max-w-2xl mx-auto mt-3">Select the plan that fits your investment strategy and start earning.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="relative group bg-white/80 backdrop-blur-md rounded-2xl shadow-xl border border-gray-200 transition duration-300 hover:scale-[1.03] hover:shadow-2xl">
                    <div class="p-8 text-center">
                        <h3 class="text-2xl font-semibold text-horizon-800 mb-2"><?php echo e($plan->name); ?></h3>
                        
                        <div class="text-3xl font-bold text-gold-500 mb-2">
                            $<?php echo e(number_format($plan->min_price, 2)); ?> - $<?php echo e(number_format($plan->max_price, 2)); ?>

                        </div>

                        <div class="text-secondary-500 text-sm mb-4">Min &mdash; Max Investment</div>

                        <ul class="mb-6 text-secondary-700 text-sm space-y-3">
                            <li class="flex items-center justify-center gap-2">
                                <span class="font-medium text-horizon-700">Daily ROI:</span> <?php echo e($plan->increment_amount); ?>% 
                            </li>
                            <li class="flex items-center justify-center gap-2">
                                <span class="font-medium text-horizon-700">Expected Return:</span> <?php echo e($plan->expected_return); ?>%
                            </li>
                            <!--<li class="flex items-center justify-center gap-2">-->
                            <!--    <span class="font-medium text-horizon-700">Gift Bonus:</span> $<?php echo e(number_format($plan->gift, 2)); ?>-->
                            <!--</li>-->
                            <?php if($plan->increment_amount): ?>
                                <li class="flex items-center justify-center gap-2">
                                    <span class="font-medium text-horizon-700">Increment:</span> +<?php echo e($plan->increment_amount); ?>%
                                     <?php echo e($plan->increment_interval); ?> 
                                </li>
                            <?php endif; ?>
                        </ul>

                        <a href="<?php echo e(route('register')); ?>" class="inline-block mt-4 px-6 py-2 bg-horizon-700 text-white rounded-lg font-medium hover:bg-horizon-800 transition-all">
                            Get Started
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>


    <!-- Testimonials Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <span class="text-gold-500 font-medium">Our Testimonials</span>
                <h2 class="text-3xl font-display font-bold text-horizon-800 mt-2">What Our Clients Say</h2>
            </div>

        <div class="testimonial-container">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Testimonial 1 -->
                <div class="testimonial-card bg-white rounded-lg shadow-sm p-8 relative">
                    <div class="text-gold-500 text-4xl absolute top-4 right-4 opacity-20">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <p class="text-secondary-700 mb-8"><?php echo e($settings->site_name); ?> has been a game-changer for me. The ease of use and reliable returns on my crypto investments make it my go-to platform. Highly recommended!</p>
                    <div class="flex items-center border-t border-gray-100 pt-4">
                        <div class="w-12 h-12 rounded-full overflow-hidden mr-4">
                            <img src="assets/img/testimonials/cl1.jpg" alt="Alex Cruis" class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-semibold text-horizon-800">Alex Cruis</h4>
                            <p class="text-secondary-600 text-sm">Crypto Enthusiast</p>
                        </div>
                    </div>
                </div>

                <!-- Testimonial 2 -->
                <div class="testimonial-card bg-white rounded-lg shadow-sm p-8 relative">
                    <div class="text-gold-500 text-4xl absolute top-4 right-4 opacity-20">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <p class="text-secondary-700 mb-8">I've tried various crypto platforms, but <?php echo e($settings->site_name); ?> stands out. Their secure environment and responsive support make it a top choice for anyone venturing into crypto investments.</p>
                    <div class="flex items-center border-t border-gray-100 pt-4">
                        <div class="w-12 h-12 rounded-full overflow-hidden mr-4">
                            <img src="assets/img/testimonials/cl2.jpg" alt="Marion Ott" class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-semibold text-horizon-800">Marion Ott</h4>
                            <p class="text-secondary-600 text-sm">Blockchain Analyst</p>
                        </div>
                    </div>
                </div>

                <!-- Testimonial 3 -->
                <div class="testimonial-card bg-white rounded-lg shadow-sm p-8 relative">
                    <div class="text-gold-500 text-4xl absolute top-4 right-4 opacity-20">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <p class="text-secondary-700 mb-8"><?php echo e($settings->site_name); ?>'s intuitive interface and transparent investment strategies have given me confidence in navigating the crypto market. It's a reliable platform for both beginners and experienced investors.</p>
                    <div class="flex items-center border-t border-gray-100 pt-4">
                        <div class="w-12 h-12 rounded-full overflow-hidden mr-4">
                            <img src="assets/img/testimonials/cl3.jpg" alt="Harry Jackson" class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-semibold text-horizon-800">Harry Jackson</h4>
                            <p class="text-secondary-600 text-sm">Crypto Investor</p>
                        </div>
                    </div>
                </div>

                <!-- Additional testimonials for rotation -->
                <div class="testimonial-card bg-white rounded-lg shadow-sm p-8 relative" style="display: none;">
                    <div class="text-gold-500 text-4xl absolute top-4 right-4 opacity-20">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <p class="text-secondary-700 mb-8">As an entrepreneur, <?php echo e($settings->site_name); ?> has become an essential tool for managing my crypto portfolio. The platform's reliability and innovative features contribute to the success of my ventures.</p>
                    <div class="flex items-center border-t border-gray-100 pt-4">
                        <div class="w-12 h-12 rounded-full overflow-hidden mr-4">
                            <img src="assets/img/testimonials/cl4.jpg" alt="Brock Lee" class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-semibold text-horizon-800">Brock Lee</h4>
                            <p class="text-secondary-600 text-sm">Entrepreneur</p>
                        </div>
                    </div>
                </div>

                <div class="testimonial-card bg-white rounded-lg shadow-sm p-8 relative" style="display: none;">
                    <div class="text-gold-500 text-4xl absolute top-4 right-4 opacity-20">
                        <i class="fas fa-quote-right"></i>
                    </div>
                    <p class="text-secondary-700 mb-8"><?php echo e($settings->site_name); ?>'s commitment to security and user-friendly features has made my crypto journey enjoyable. I appreciate the platform's continuous efforts to enhance the user experience.</p>
                    <div class="flex items-center border-t border-gray-100 pt-4">
                        <div class="w-12 h-12 rounded-full overflow-hidden mr-4">
                            <img src="assets/img/testimonials/cl5.png" alt="Nina Smith" class="w-full h-full object-cover">
                        </div>
                        <div>
                            <h4 class="font-semibold text-horizon-800">Nina Smith</h4>
                            <p class="text-secondary-600 text-sm">Crypto Enthusiast</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

    <!-- Explore More Section -->
    <section class="py-16">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <p class="text-horizon-800 font-semibold mb-2">WE ARE HERE FOR YOU</p>
                <h2 class="text-3xl font-display font-bold text-horizon-800">Explore More</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Card 1 -->
                <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                    <div class="h-48 overflow-hidden">
                        <img src="img/2-2.jpg" alt="Excellence Record" class="w-full h-full object-cover">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-semibold text-horizon-800 mb-3">Excellence Record</h3>
                        <p class="text-secondary-700">Your Stock broker will hold your funds. Thus, it is important you register it is safe.</p>
                    </div>
                </div>

                <!-- Card 2 -->
                <div class="bg-white rounded-lg shadow-sm overflow-hidden">
                    <div class="h-48 overflow-hidden">
                        <img src="img/3.jpg" alt="Client Success" class="w-full h-full object-cover">
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-semibold text-horizon-800 mb-3">We Genuinely Want Our Clients to Succeed</h3>
                        <p class="text-secondary-700">Genuinely, we want to see you succeed. Once you open an account with us, we will hold your capital in trust.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Investment Goals Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- Image Column -->
                <div class="relative">
                    <img src="new/4.jpg" alt="Investment Goals" class="w-full h-auto rounded-lg shadow-lg">
                    <div class="absolute -top-4 -left-4 w-24 h-24 bg-gold-500 rounded-full animate-pulse opacity-20"></div>
                    <div class="absolute -bottom-4 -right-4 w-16 h-16 bg-horizon-500 rounded-full animate-pulse opacity-20"></div>
                </div>

                <!-- Content Column -->
                <div>
                    <span class="text-horizon-700 font-medium">Investment Goals</span>
                    <h2 class="text-3xl font-display font-bold text-horizon-800 mt-2 mb-6">Manage Your Crypto Portfolio With <?php echo e($settings->site_name); ?></h2>
                    <p class="text-secondary-700 mb-8"><?php echo e($settings->site_name); ?>'s Crypto Investment platform empowers users to make strategic decisions and conduct seamless transactions in the world of digital assets. Our platform, developed in collaboration with leading blockchain experts, ensures secure and instant transactions with cryptocurrencies.</p>

                    <ul class="space-y-4">
                        <li class="flex items-start">
                            <div class="flex-shrink-0 mt-1 text-gold-500">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <p class="ml-3 text-secondary-700">Diversify Your Crypto Portfolio</p>
                        </li>
                        <li class="flex items-start">
                            <div class="flex-shrink-0 mt-1 text-gold-500">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <p class="ml-3 text-secondary-700">Set Financial Goals for Your Investments</p>
                        </li>
                        <li class="flex items-start">
                            <div class="flex-shrink-0 mt-1 text-gold-500">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <p class="ml-3 text-secondary-700">Stay Informed About Crypto Trends</p>
                        </li>
                        <li class="flex items-start">
                            <div class="flex-shrink-0 mt-1 text-gold-500">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <p class="ml-3 text-secondary-700">Securely Manage Your Cryptocurrencies</p>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Counter Section -->
    <section class="py-16 bg-horizon-700 text-white">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Counter 1 -->
                <div class="text-center">
                    <div class="text-4xl md:text-5xl font-bold mb-2">
                        <span class="counter" data-count="9430">0</span>
                    </div>
                    <p class="text-lg">Satisfied Investors</p>
                </div>

                <!-- Counter 2 -->
                <div class="text-center">
                    <div class="text-4xl md:text-5xl font-bold mb-2">
                        <span class="counter" data-count="15">0</span>
                    </div>
                    <p class="text-lg">Years in Crypto Investment</p>
                </div>

                <!-- Counter 3 -->
                <div class="text-center">
                    <div class="text-4xl md:text-5xl font-bold mb-2">
                        <span class="counter" data-count="197">0</span>
                    </div>
                    <p class="text-lg">Global Presence</p>
                </div>

                <!-- Counter 4 -->
                <div class="text-center">
                    <div class="text-4xl md:text-5xl font-bold mb-2">
                        <span class="counter" data-count="30467">0</span>
                    </div>
                    <p class="text-lg">Successful Investment Transactions</p>
                </div>
            </div>
        </div>
    </section>

    <script data-cfasync="false" src="https://cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script>
    $(document).ready(function() {
        // Improved Hero Slider
        let currentSlide = 0;
        const slides = $('.hero-slide-item');
        const totalSlides = slides.length;
        const dots = $('.slider-dot');

        // Set first slide and dot as active
        slides.eq(0).show();
        dots.eq(0).addClass('bg-opacity-100');

        // Function to change slide
        function goToSlide(index) {
            // Hide current slide
            slides.eq(currentSlide).fadeOut(500);
            dots.eq(currentSlide).removeClass('bg-opacity-100').addClass('bg-opacity-50');

            // Show new slide
            currentSlide = index;
            slides.eq(currentSlide).fadeIn(500);
            dots.eq(currentSlide).removeClass('bg-opacity-50').addClass('bg-opacity-100');
        }

        // Auto-advance slides
        let slideInterval = setInterval(function() {
            const nextSlide = (currentSlide + 1) % totalSlides;
            goToSlide(nextSlide);
        }, 5000);

        // Click on dots to change slide
        dots.click(function() {
            const slideIndex = $(this).data('slide');
            if (slideIndex !== currentSlide) {
                clearInterval(slideInterval);
                goToSlide(slideIndex);

                // Restart auto-advance
                slideInterval = setInterval(function() {
                    const nextSlide = (currentSlide + 1) % totalSlides;
                    goToSlide(nextSlide);
                }, 5000);
            }
        });

        // Counter Animation
        function animateCounters() {
            $('.counter').each(function() {
                var $this = $(this);
                var countTo = parseInt($this.attr('data-count'));

                $({ countNum: 0 }).animate({
                    countNum: countTo
                }, {
                    duration: 2000,
                    easing: 'swing',
                    step: function() {
                        $this.text(Math.floor(this.countNum).toLocaleString());
                    },
                    complete: function() {
                        $this.text(countTo.toLocaleString());
                    }
                });
            });
        }

        // Trigger counter animation when section is visible
        function checkCounters() {
            const counterSection = $('.counter').first().closest('section');
            if (counterSection.length) {
                const sectionTop = counterSection.offset().top;
                const sectionHeight = counterSection.outerHeight();
                const windowTop = $(window).scrollTop();
                const windowHeight = $(window).height();

                if (windowTop + windowHeight > sectionTop + 100) {
                    animateCounters();
                    $(window).off('scroll', checkCounters); // Remove listener after animation
                }
            }
        }

        $(window).on('scroll', checkCounters);

        // Simple testimonial rotation
        let currentTestimonial = 0;
        const testimonials = $('.testimonial-card');
        const totalTestimonials = testimonials.length;

        if (totalTestimonials > 3) {
            // Show first 3 testimonials
            testimonials.hide().slice(0, 3).show();

            setInterval(function() {
                testimonials.hide();
                for (let i = 0; i < 3; i++) {
                    const index = (currentTestimonial + i) % totalTestimonials;
                    testimonials.eq(index).fadeIn(500);
                }
                currentTestimonial = (currentTestimonial + 1) % totalTestimonials;
            }, 6000);
        }
    });
</script>
        </div>
    </main>






<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            // Improved Hero Slider
            let currentSlide = 0;
            const slides = $('.hero-slider__slide');
            const totalSlides = slides.length;

            function showSlide(index) {
                slides.removeClass('active');
                slides.eq(index).addClass('active');
            }

            function nextSlide() {
                currentSlide = (currentSlide + 1) % totalSlides;
                showSlide(currentSlide);
            }

            setInterval(nextSlide, 5000); // Change slide every 5 seconds
        });
    </script>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\brembypro\resources\views/home/index.blade.php ENDPATH**/ ?>