<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('title', 'About Us'); ?>


<?php $__env->startSection('content'); ?>




    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
                <!-- Hero Section -->
    <section class="relative bg-horizon-700 py-20 md:py-28 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-br from-horizon-800 via-horizon-700 to-horizon-600"></div>
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-10 left-10 w-32 h-32 bg-gold-500 rounded-full animate-pulse"></div>
            <div class="absolute bottom-20 right-20 w-24 h-24 bg-gold-400 rounded-full animate-pulse delay-1000"></div>
            <div class="absolute top-1/2 left-1/4 w-16 h-16 bg-gold-300 rounded-full animate-pulse delay-500"></div>
        </div>

        <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-12">
                    <div class="inline-block bg-gold-500 text-white px-4 py-2 rounded-full text-sm font-semibold mb-6 uppercase tracking-wide">
                        About <?php echo e($settings->site_name); ?>

                    </div>
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-display font-bold text-white leading-tight mb-6">
                        Next-Generation <span class="text-gold-500">Trading Platform</span>
                    </h1>
                    <p class="text-xl md:text-2xl text-white text-opacity-90 mb-8 max-w-3xl mx-auto">
                        Empowering traders worldwide with advanced automation, expert copy trading, and comprehensive market access since 2018
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
                    <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-xl p-6 text-center">
                        <div class="text-4xl font-bold text-gold-400 mb-2">15,000+</div>
                        <div class="text-white text-opacity-90">Active Traders Worldwide</div>
                    </div>
                    <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-xl p-6 text-center">
                        <div class="text-4xl font-bold text-gold-400 mb-2">$2.3M+</div>
                        <div class="text-white text-opacity-90">Profits Paid to Users</div>
                    </div>
                    <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-xl p-6 text-center">
                        <div class="text-4xl font-bold text-gold-400 mb-2">98.7%</div>
                        <div class="text-white text-opacity-90">Customer Satisfaction</div>
                    </div>
                </div>

                <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-2xl p-8 md:p-10">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
                        <div>
                            <h3 class="text-2xl md:text-3xl font-bold text-white mb-4">
                                <span class="text-gold-400">Professional Team</span> of Trading Experts
                            </h3>
                            <p class="text-white text-opacity-90 leading-relaxed mb-6">
                                <?php echo e($settings->site_name); ?> was founded by a team of Wall Street veterans, cryptocurrency pioneers, and AI technology leaders. With over 50 years of combined experience in financial markets, we've developed cutting-edge trading infrastructure that democratizes professional-grade tools.
                            </p>
                            <p class="text-white text-opacity-90 leading-relaxed">
                                Our proprietary algorithms analyze millions of data points per second across crypto, forex, stocks, and commodities markets to identify profitable opportunities for our users 24/7.
                            </p>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <div class="bg-white bg-opacity-10 rounded-lg p-4 text-center">
                                <i class="fas fa-robot text-3xl text-gold-400 mb-2"></i>
                                <div class="text-white font-semibold">AI-Powered Bots</div>
                            </div>
                            <div class="bg-white bg-opacity-10 rounded-lg p-4 text-center">
                                <i class="fas fa-users text-3xl text-gold-400 mb-2"></i>
                                <div class="text-white font-semibold">Expert Copy Trading</div>
                            </div>
                            <div class="bg-white bg-opacity-10 rounded-lg p-4 text-center">
                                <i class="fas fa-chart-line text-3xl text-gold-400 mb-2"></i>
                                <div class="text-white font-semibold">8 Asset Classes</div>
                            </div>
                            <div class="bg-white bg-opacity-10 rounded-lg p-4 text-center">
                                <i class="fas fa-shield-alt text-3xl text-gold-400 mb-2"></i>
                                <div class="text-white font-semibold">Bank-Grade Security</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="absolute bottom-0 left-0 right-0 h-16 bg-gradient-to-t from-white to-transparent"></div>
    </section>

    <!-- Platform Overview Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mb-4">
                        Complete Trading <span class="text-gold-600">Ecosystem</span>
                    </h2>
                    <p class="text-lg text-secondary-600 max-w-3xl mx-auto">
                        From beginner-friendly automation to professional manual trading - everything you need in one powerful platform
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
                    <!-- Copy Trading -->
                    <div class="bg-gradient-to-br from-green-50 to-green-50 rounded-2xl p-6 border-2 border-green-100 hover:border-green-300 transition-all hover:-translate-y-1 hover:shadow-xl">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mb-4">
                            <i class="fas fa-users text-white text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-horizon-800 mb-3">Copy Trading</h3>
                        <p class="text-secondary-700 mb-4 text-sm">Follow 50+ verified expert traders and automatically replicate their strategies</p>
                        <div class="bg-white rounded-lg p-3 text-center">
                            <div class="text-2xl font-bold text-green-600">15-25%</div>
                            <div class="text-xs text-secondary-600">Monthly ROI</div>
                        </div>
                    </div>

                    <!-- Bot Trading -->
                    <div class="bg-gradient-to-br from-green-50 to-emerald-50 rounded-2xl p-6 border-2 border-green-100 hover:border-green-300 transition-all hover:-translate-y-1 hover:shadow-xl">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mb-4">
                            <i class="fas fa-robot text-white text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-horizon-800 mb-3">Bot Trading</h3>
                        <p class="text-secondary-700 mb-4 text-sm">Deploy AI-powered bots that trade 24/7 with pre-configured strategies</p>
                        <div class="bg-white rounded-lg p-3 text-center">
                            <div class="text-2xl font-bold text-green-600">18-32%</div>
                            <div class="text-xs text-secondary-600">Yearly Returns</div>
                        </div>
                    </div>

                    <!-- Crypto Staking -->
                    <div class="bg-gradient-to-br from-green-50 to-pink-50 rounded-2xl p-6 border-2 border-green-100 hover:border-green-300 transition-all hover:-translate-y-1 hover:shadow-xl">
                        <div class="w-12 h-12 bg-gradient-to-br from-green-500 to-green-600 rounded-lg flex items-center justify-center mb-4">
                            <i class="fas fa-coins text-white text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-horizon-800 mb-3">Crypto Staking</h3>
                        <p class="text-secondary-700 mb-4 text-sm">Earn passive rewards by staking major cryptocurrencies with daily payouts</p>
                        <div class="bg-white rounded-lg p-3 text-center">
                            <div class="text-2xl font-bold text-green-600">5-15%</div>
                            <div class="text-xs text-secondary-600">APR Returns</div>
                        </div>
                    </div>

                    <!-- Manual Trading -->
                    <div class="bg-gradient-to-br from-orange-50 to-red-50 rounded-2xl p-6 border-2 border-orange-100 hover:border-orange-300 transition-all hover:-translate-y-1 hover:shadow-xl">
                        <div class="w-12 h-12 bg-gradient-to-br from-orange-500 to-orange-600 rounded-lg flex items-center justify-center mb-4">
                            <i class="fas fa-chart-line text-white text-xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-horizon-800 mb-3">Manual Trading</h3>
                        <p class="text-secondary-700 mb-4 text-sm">Full control with professional charting tools and real-time market data</p>
                        <div class="bg-white rounded-lg p-3 text-center">
                            <div class="text-2xl font-bold text-orange-600">Unlimited</div>
                            <div class="text-xs text-secondary-600">Potential</div>
                        </div>
                    </div>
                </div>

                <!-- Market Access -->
                <div class="bg-gray-50 rounded-2xl p-8 md:p-12">
                    <h3 class="text-2xl font-bold text-horizon-800 mb-8 text-center">Trade 8 Major Asset Classes</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                        <div class="text-center">
                            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fab fa-bitcoin text-green-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Cryptocurrencies</div>
                            <div class="text-sm text-secondary-600">100+ pairs</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-dollar-sign text-green-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Forex</div>
                            <div class="text-sm text-secondary-600">50+ pairs</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-chart-bar text-green-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Stocks</div>
                            <div class="text-sm text-secondary-600">500+ companies</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-orange-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-coins text-orange-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Commodities</div>
                            <div class="text-sm text-secondary-600">Gold, Oil, Silver</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-landmark text-green-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Indices</div>
                            <div class="text-sm text-secondary-600">S&P, NASDAQ, DOW</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-teal-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-certificate text-teal-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Bonds & ETFs</div>
                            <div class="text-sm text-secondary-600">Gov & Corporate</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-pink-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-tasks text-pink-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Options</div>
                            <div class="text-sm text-secondary-600">Calls & Puts</div>
                        </div>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-briefcase text-yellow-600 text-2xl"></i>
                            </div>
                            <div class="font-semibold text-horizon-800">Portfolios</div>
                            <div class="text-sm text-secondary-600">Managed Funds</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Company Registration Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <!-- Certificate and Company Info -->
                    <div class="space-y-8">
                        <div class="bg-gray-50 rounded-lg p-8 text-center">
                            
                            <div class="bg-white rounded-lg shadow-sm p-6">
                                <h4 class="text-lg font-semibold text-horizon-800 mb-4">Company Information</h4>
                                <div class="space-y-3 text-left">
                                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                        <span class="font-medium text-secondary-600">Reg name:</span>
                                        <span class="text-horizon-800"><?php echo e($settings->site_name); ?> LTD</span>
                                    </div>
                                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                                        <span class="font-medium text-secondary-600">Number:</span>
                                        <a href="#" target="_blank" class="text-gold-600 hover:text-gold-700 font-medium">#13699699</a>
                                    </div>
                                    <div class="flex justify-between items-start py-2">
                                        <span class="font-medium text-secondary-600">Official address:</span>
                                        <span class="text-horizon-800 text-right">55 Aylmer Road, East Finchley, London, United Kingdom, N2 0AT</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Company Description -->
                    <div>
                        <h3 class="text-3xl font-display font-bold text-horizon-800 mb-6">
                            Officially Registered <span class="text-gold-600">Company</span>
                        </h3>
                        <div class="text-4xl font-bold text-gold-600 mb-6">
                            <a href="#" class="hover:text-gold-700 transition-colors duration-200">#13699699</a>
                        </div>
                        <div class="bg-gold-50 border-l-4 border-gold-500 p-6 rounded-r-lg mb-6">
                            <blockquote class="text-lg font-medium text-horizon-800">
                                <?php echo e($settings->site_name); ?> - UK LEGAL REGISTRATION
                                <a href="#" class="text-gold-600 hover:text-gold-700">№13699699</a>
                            </blockquote>
                        </div>
                        <p class="text-secondary-700 leading-relaxed">
                            The unique development of our company has an official legal registration. You can check this information by clicking on the registration number.
                        </p>
                        <div class="mt-8">
                            Due to its widespread use as filler text for layouts, non-readability is of great importance.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Statistics Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mb-4">
                        <span class="text-gold-600"><?php echo e($settings->site_name); ?></span> Statistics
                    </h2>
                    <p class="text-lg text-secondary-600 max-w-4xl mx-auto leading-relaxed">
                        Here are online statistics of our company. Competent distribution of investments in the <?php echo e($settings->site_name); ?> robot allows you to maximize profits at all stages of the market. Gradual development is a guarantee of world recognition in the market.
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <!-- Days in Work -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-gold-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <div class="text-3xl font-bold text-horizon-800 mb-2 counter" data-count="2145">0</div>
                        <p class="text-secondary-600 font-medium">Days in Work</p>
                    </div>

                    <!-- Total Members -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-gold-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                            </svg>
                        </div>
                        <div class="text-3xl font-bold text-horizon-800 mb-2 counter" data-count="89650">0</div>
                        <p class="text-secondary-600 font-medium">Total Members</p>
                    </div>

                    <!-- Total Invested -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-gold-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                        <div class="text-2xl font-bold text-horizon-800 mb-2">
                            <span class="counter" data-count="338400989">0</span>
                            <span class="text-lg text-secondary-600">USD</span>
                        </div>
                        <p class="text-secondary-600 font-medium">Total Invested</p>
                    </div>

                    <!-- Total Paid -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-gold-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                            </svg>
                        </div>
                        <div class="text-2xl font-bold text-horizon-800 mb-2">
                            <span class="counter" data-count="101689885">0</span>
                            <span class="text-lg text-secondary-600">USD</span>
                        </div>
                        <p class="text-secondary-600 font-medium">Total Paid</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Referral Program Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <!-- Referral Info -->
                    <div>
                        <h3 class="text-3xl font-display font-bold text-horizon-800 mb-6">
                            Referral <span class="text-gold-600">Program</span>
                        </h3>
                        <p class="text-lg text-secondary-700 mb-8 leading-relaxed">
                            Anyone can take part in the affiliate program. It allows you to receive generous rewards by inviting new members.
                        </p>

                        <div class="bg-gradient-to-r from-horizon-700 to-horizon-600 rounded-lg p-8 text-white mb-8">
                            <h4 class="text-xl font-semibold mb-4 text-gold-400">4 Levels of Referral Program</h4>
                            <p class="mb-6 text-white text-opacity-90">
                                Get extra profit when people in your structure invite new investors to the company
                            </p>
                            <div class="text-center">
                                <div class="text-4xl md:text-5xl font-bold text-gold-400 leading-tight">
                                    7<sup class="text-2xl">%</sup> - 3<sup class="text-2xl">%</sup><br>
                                    2<sup class="text-2xl">%</sup> - 1<sup class="text-2xl">%</sup>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Referral Image -->
                    <div class="text-center">
                        <div class="relative inline-block">
                            <img src="temp/custom/assets/images/investment/notebook.png" alt="Investment Platform" class="max-w-full h-auto rounded-lg shadow-lg">
                            <div class="absolute inset-0 flex items-center justify-center">
                                <button class="w-16 h-16 bg-gold-500 hover:bg-gold-600 rounded-full flex items-center justify-center text-white shadow-lg transition-colors duration-200">
                                    <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M8 5v14l11-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Technology & Security Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mb-4">
                        Cutting-Edge <span class="text-gold-600">Technology & Security</span>
                    </h2>
                    <p class="text-lg text-secondary-600 max-w-3xl mx-auto">
                        Enterprise-grade infrastructure built for speed, reliability, and maximum security
                    </p>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-12">
                    <!-- Security Features -->
                    <div class="bg-gradient-to-br from-horizon-50 to-green-50 rounded-2xl p-8 border-2 border-horizon-100">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-horizon-700 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-shield-alt text-white text-xl"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-horizon-800">Military-Grade Security</h3>
                        </div>
                        <ul class="space-y-4">
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">256-bit SSL Encryption</div>
                                    <div class="text-sm text-secondary-600">Same security used by major banks</div>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">Two-Factor Authentication</div>
                                    <div class="text-sm text-secondary-600">Extra layer of account protection</div>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">Cold Storage Wallets</div>
                                    <div class="text-sm text-secondary-600">95% of crypto assets offline</div>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">Regular Security Audits</div>
                                    <div class="text-sm text-secondary-600">Third-party penetration testing</div>
                                </div>
                            </li>
                        </ul>
                    </div>

                    <!-- Technology Features -->
                    <div class="bg-gradient-to-br from-gold-50 to-yellow-50 rounded-2xl p-8 border-2 border-gold-100">
                        <div class="flex items-center mb-6">
                            <div class="w-12 h-12 bg-gold-600 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-microchip text-white text-xl"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-horizon-800">Advanced Technology</h3>
                        </div>
                        <ul class="space-y-4">
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">AI-Powered Algorithms</div>
                                    <div class="text-sm text-secondary-600">Machine learning for better predictions</div>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">Sub-Second Execution</div>
                                    <div class="text-sm text-secondary-600">Lightning-fast order processing</div>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">99.9% Uptime SLA</div>
                                    <div class="text-sm text-secondary-600">Enterprise-grade reliability</div>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                <div>
                                    <div class="font-semibold text-horizon-800">Real-Time Data Feeds</div>
                                    <div class="text-sm text-secondary-600">Direct exchange connections</div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Trust Indicators -->
                <div class="bg-gray-50 rounded-2xl p-8">
                    <h3 class="text-xl font-bold text-horizon-800 mb-6 text-center">Trusted by Traders Worldwide</h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
                        <div>
                            <div class="text-3xl font-bold text-horizon-800 mb-1">150+</div>
                            <div class="text-sm text-secondary-600">Countries Supported</div>
                        </div>
                        <div>
                            <div class="text-3xl font-bold text-horizon-800 mb-1">$500M+</div>
                            <div class="text-sm text-secondary-600">Trading Volume</div>
                        </div>
                        <div>
                            <div class="text-3xl font-bold text-horizon-800 mb-1">24/7</div>
                            <div class="text-sm text-secondary-600">Customer Support</div>
                        </div>
                        <div>
                            <div class="text-3xl font-bold text-horizon-800 mb-1">Licensed</div>
                            <div class="text-sm text-secondary-600">Fully Regulated</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Advantages Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl font-display font-bold text-horizon-800 mb-4">Our Advantages</h2>
                    <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                        Discover what makes <?php echo e($settings->site_name); ?> the preferred choice for cryptocurrency investments
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <!-- 24/7 Trading -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-horizon-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-horizon-800 mb-3">24/7 Robot Trading</h4>
                        <p class="text-secondary-600">Robot trading without weekends and holidays</p>
                    </div>

                    <!-- 24/7 Withdrawal -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-horizon-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-horizon-800 mb-3">Instant Withdrawal</h4>
                        <p class="text-secondary-600">Withdrawal 24/7</p>
                    </div>

                    <!-- Payment Systems -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-horizon-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-horizon-800 mb-3">Multiple Payments</h4>
                        <p class="text-secondary-600">Big number of payment systems</p>
                    </div>

                    <!-- Anonymous -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-horizon-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-horizon-800 mb-3">100% Anonymous</h4>
                        <p class="text-secondary-600">100% anonymous and transparency of the work of the robot</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Payment Systems Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <!-- Payment Image -->
                    <div class="text-center lg:text-left">
                        <img src="temp/custom/assets/images/payments/payment.png" alt="Payment Systems" class="max-w-full h-auto rounded-lg shadow-lg">
                    </div>

                    <!-- Payment Info -->
                    <div>
                        <h3 class="text-3xl font-display font-bold text-horizon-800 mb-6">
                            Payment <span class="text-gold-600">Systems</span>
                        </h3>
                        <p class="text-lg text-secondary-700 mb-6 leading-relaxed">
                            <?php echo e($settings->site_name); ?> supports a big number of payment systems
                        </p>
                        <p class="text-secondary-700 mb-8 leading-relaxed">
                            Our company does not charge commissions for opening a deposit, as well as withdrawing funds from the platform
                        </p>
                        <div>
                            <a href="login" class="inline-flex items-center px-8 py-3 border-2 border-horizon-700 text-base font-medium rounded-md text-horizon-700 bg-transparent hover:bg-horizon-700 hover:text-white focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-horizon-500 transition-colors duration-200">
                                <span>INVEST NOW</span>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 ml-2" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L12.586 11H5a1 1 0 110-2h7.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-4xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl font-display font-bold text-horizon-800 mb-4">
                        Frequently Asked <span class="text-gold-600">Questions</span>
                    </h2>
                    <p class="text-lg text-secondary-600">Everything you need to know about trading with <?php echo e($settings->site_name); ?></p>
                </div>

                <div class="space-y-4" x-data="{selected:1}">
                    <!-- Question 1 -->
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                        <button
                            @click="selected !== 1 ? selected = 1 : selected = null"
                            class="flex justify-between items-center w-full px-6 py-5 text-left hover:bg-gray-50 transition-colors"
                        >
                            <span class="text-lg font-semibold text-horizon-800">What makes <?php echo e($settings->site_name); ?> different from other platforms?</span>
                            <svg
                                :class="{'rotate-180': selected === 1}"
                                class="h-6 w-6 text-gold-600 transform transition-transform duration-200"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 20 20"
                                fill="currentColor"
                            >
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div
                            x-show="selected === 1"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="px-6 pb-5 text-secondary-700 leading-relaxed"
                        >
                            <?php echo e($settings->site_name); ?> combines multiple trading methods (copy trading, bot trading, manual trading, staking) in one platform. We offer access to 8 asset classes including crypto, forex, stocks, and commodities. Our AI-powered bots and 50+ expert traders provide automation options for all skill levels, while professional tools serve advanced traders.
                        </div>
                    </div>

                    <!-- Question 2 -->
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                        <button
                            @click="selected !== 2 ? selected = 2 : selected = null"
                            class="flex justify-between items-center w-full px-6 py-5 text-left hover:bg-gray-50 transition-colors"
                        >
                            <span class="text-lg font-semibold text-horizon-800">Is my money safe with <?php echo e($settings->site_name); ?>?</span>
                            <svg
                                :class="{'rotate-180': selected === 2}"
                                class="h-6 w-6 text-gold-600 transform transition-transform duration-200"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 20 20"
                                fill="currentColor"
                            >
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div
                            x-show="selected === 2"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="px-6 pb-5 text-secondary-700 leading-relaxed"
                        >
                            Absolutely. We use 256-bit SSL encryption, two-factor authentication, and store 95% of crypto assets in cold storage wallets. We're fully licensed and regulated, undergo regular third-party security audits, and maintain comprehensive insurance coverage. Your funds are segregated from company operations.
                        </div>
                    </div>

                    <!-- Question 3 -->
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                        <button
                            @click="selected !== 3 ? selected = 3 : selected = null"
                            class="flex justify-between items-center w-full px-6 py-5 text-left hover:bg-gray-50 transition-colors"
                        >
                            <span class="text-lg font-semibold text-horizon-800">Do I need trading experience to get started?</span>
                            <svg
                                :class="{'rotate-180': selected === 3}"
                                class="h-6 w-6 text-gold-600 transform transition-transform duration-200"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 20 20"
                                fill="currentColor"
                            >
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div
                            x-show="selected === 3"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="px-6 pb-5 text-secondary-700 leading-relaxed"
                        >
                            Not at all! Beginners can start with copy trading (follow expert traders automatically) or staking (passive income with zero effort). We provide 5,000+ free educational resources, video tutorials, live webinars, and 24/7 support. Advanced traders get professional charting tools and indicators.
                        </div>
                    </div>

                    <!-- Question 4 -->
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                        <button
                            @click="selected !== 4 ? selected = 4 : selected = null"
                            class="flex justify-between items-center w-full px-6 py-5 text-left hover:bg-gray-50 transition-colors"
                        >
                            <span class="text-lg font-semibold text-horizon-800">What is the minimum investment amount?</span>
                            <svg
                                :class="{'rotate-180': selected === 4}"
                                class="h-6 w-6 text-gold-600 transform transition-transform duration-200"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 20 20"
                                fill="currentColor"
                            >
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div
                            x-show="selected === 4"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="px-6 pb-5 text-secondary-700 leading-relaxed"
                        >
                            Minimums vary by trading method: Manual Trading $50, Staking $50, Copy Trading $100, and Bot Trading $200. We recommend starting with at least $500 for optimal portfolio diversification across multiple strategies.
                        </div>
                    </div>

                    <!-- Question 5 -->
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                        <button
                            @click="selected !== 5 ? selected = 5 : selected = null"
                            class="flex justify-between items-center w-full px-6 py-5 text-left hover:bg-gray-50 transition-colors"
                        >
                            <span class="text-lg font-semibold text-horizon-800">How do withdrawals work?</span>
                            <svg
                                :class="{'rotate-180': selected === 5}"
                                class="h-6 w-6 text-gold-600 transform transition-transform duration-200"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 20 20"
                                fill="currentColor"
                            >
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div
                            x-show="selected === 5"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="px-6 pb-5 text-secondary-700 leading-relaxed"
                        >
                            You can withdraw anytime (except fixed-term staking). Crypto withdrawals process within 1 hour, bank transfers take 1-3 business days. Minimum withdrawal is $25 with transparent fees. We process withdrawals 24/7 with no hidden charges.
                        </div>
                    </div>

                    <!-- Question 6 -->
                    <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                        <button
                            @click="selected !== 6 ? selected = 6 : selected = null"
                            class="flex justify-between items-center w-full px-6 py-5 text-left hover:bg-gray-50 transition-colors"
                        >
                            <span class="text-lg font-semibold text-horizon-800">What payment methods do you accept?</span>
                            <svg
                                :class="{'rotate-180': selected === 6}"
                                class="h-6 w-6 text-gold-600 transform transition-transform duration-200"
                                xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 20 20"
                                fill="currentColor"
                            >
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>
                        <div
                            x-show="selected === 6"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="px-6 pb-5 text-secondary-700 leading-relaxed"
                        >
                            We accept cryptocurrencies (Bitcoin, Ethereum, USDT, and 20+ more), bank transfers, credit/debit cards (Visa, Mastercard), PayPal, Stripe, and various e-wallets. No deposit fees on most methods. Instant crypto deposits, 1-3 days for bank transfers.
                        </div>
                    </div>
                </div>

                <div class="mt-12 text-center">
                    <p class="text-secondary-600 mb-4">Still have questions?</p>
                    <a href="<?php echo e(route('contact')); ?>" class="inline-flex items-center px-8 py-3 bg-gold-500 hover:bg-gold-600 text-white font-semibold rounded-lg transition-all shadow-lg hover:shadow-xl">
                        <i class="fas fa-comments mr-2"></i>
                        Contact Our Support Team
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Back to Top Button -->
    <div id="button-up" class="hidden fixed right-6 bottom-16 bg-white text-horizon-700 rounded-full shadow-lg p-3 cursor-pointer hover:bg-gray-100 transition-all duration-300 z-50">
        <i class="fa fa-chevron-up text-xl"></i>
    </div>

    <script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script>
        $(document).ready(function() {
            // Counter Animation
            function animateCounters() {
                $('.counter').each(function() {
                    var $this = $(this);
                    var countTo = parseInt($this.attr('data-count'));

                    $({ countNum: 0 }).animate({
                        countNum: countTo
                    }, {
                        duration: 2000,
                        easing: 'swing',
                        step: function() {
                            $this.text(Math.floor(this.countNum).toLocaleString());
                        },
                        complete: function() {
                            $this.text(countTo.toLocaleString());
                        }
                    });
                });
            }

            // Trigger counter animation when section is visible
            function checkCounters() {
                const counterSection = $('.counter').first().closest('section');
                if (counterSection.length) {
                    const sectionTop = counterSection.offset().top;
                    const sectionHeight = counterSection.outerHeight();
                    const windowTop = $(window).scrollTop();
                    const windowHeight = $(window).height();

                    if (windowTop + windowHeight > sectionTop + 100) {
                        animateCounters();
                        $(window).off('scroll', checkCounters); // Remove listener after animation
                    }
                }
            }

            $(window).on('scroll', checkCounters);

            // Back to top button
            var button = $('#button-up');
            $(window).scroll(function() {
                if ($(this).scrollTop() > 300) {
                    button.fadeIn();
                } else {
                    button.fadeOut();
                }
            });

            button.on('click', function(){
                $('html, body').animate({
                    scrollTop: 0
                }, 800);
                return false;
            });
        });
    </script>
        </div>
    </main>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\brembypro\resources\views/home/about.blade.php ENDPATH**/ ?>